#include <iostream>
#include <algorithm>
#include <vector>

const int N = 2e5;

using namespace std;
typedef long long ll;

struct ln{
    ll st, ed;
};

struct xlop{
    int time;
    ll x;
};

int n;
xlop a[N]; //time, x

vector<ln> intersect(vector<ln> pr, vector<ln> cr){
    vector<ln> rs;
    int ip = 0, ic = 0;
    ln jp, jc;
    while(ip != pr.size() && ic != pr.size()){
        jp = pr[ip]; jc = cr[ic];
        if(jp.st <= jc.st && jc.st <= jp.ed){
            if(!rs.empty() && rs.back().ed >= jc.st)
                rs.back().ed = jp.ed;
            else
                rs.push_back({jc.st, jp.ed});
            ++ip;
            continue;
        }
        if(jc.st <= jp.st && jp.st <= jc.ed){
            if(!rs.empty() && rs.back().ed >= jp.st)
                rs.back().ed = jc.ed;
            else
                rs.push_back({jp.st, jc.ed});
            ++ic;
            continue;
        }
        if(jc.ed < jp.ed)
            ++ic;
        else ++ip;
    }
    return rs;
}

vector<ln> get_cr(int &i, int m){
    vector<int> bmb;
    int si = i;
    while(a[i].time == a[si].time)
        bmb.push_back(a[i].x), ++i;
    //cout << "bmb: ";
    //for(auto j: bmb)
    //    cout << j << ' '; cout << '\n';
    --i;
    //cout << "i: " << i << '\n';
    vector<ln> rs;
    int l = -a[si].time << 1;
    for(auto j: bmb){
        if(j - m >= l)
            rs.push_back({l, j - m});
        l = j + m;
        if(l > a[si].time << 1)
            return rs;
    }
    rs.push_back({l, a[si].time << 1});
    return rs;
}

void move_on(vector<ln> &nx, int on){
    for(int i = 0; i < nx.size(); ++i){
        nx[i].st -= on;
        nx[i].ed -= on;
        //cout << "nx[i]: " << nx[i].st << ", " << nx[i].ed << '\n';
    }
}

bool check(int m){
    vector<ln> cr, pr, nx;
    int to_nx = n ?a[0].time << 1 :0;
    pr.push_back({-to_nx, to_nx});
    for(int i = 0; i < n; ++i){
        cr = get_cr(i, m);
        /*cout << "cr:\n";
        for(auto j: cr)
            cout << j.st << ' ' << j.ed << '\n';//*/
        if(cr.empty())
            return 0;
        nx = intersect(pr, cr);
        to_nx = 0;
        if(i != n - 1)
            to_nx = (a[i + 1].time - a[i].time) << 1;
        move_on(nx, to_nx);
        /*cout << "nx: " << '\n';
        for(auto j: nx)
            cout << j.st << ' ' << j.ed << '\n';
        cout.flush();//*/
        if(nx.empty()){
            //cout << "return 0" << '\n';
            return 0;
        }
        pr = nx;
    }
    //cout << "return " << !pr.empty() << '\n';
    return !pr.empty();
}

bool srt(xlop a, xlop b){
    if(a.time == b.time)
        return a.x < b.x;
    return a.time < b.time;
}

int main(){
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    cin >> n;
    for(int i = 0; i < n; ++i)
        cin >> a[i].time >> a[i].x, a[i].x <<= 1;
    sort(a, a + n, srt);
    int l = 0, r = a[0].time << 2;
    while(l < r){
        int m = r + l - ((l + r) >> 1);
        if(check(m))
            l = m;
        else r = m - 1;
    }
    cout << l / 2.0;
    return 0;
}
